/*
Run this script on:

        DNS          .aac.dva.DNS   .STG    -  This database will be modified

to synchronize it with:

        DNS          .aac.dva.DNS   .STG

You are recommended to back up your database before running this script

Script created by SQL Compare version 11.1.3 from Red Gate Software Ltd at 3/28/2018 6:25:23 PM

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[COMORBIDICD10DIAGNOSISVERSION]'
GO
IF OBJECT_ID(N'[STAGING].[COMORBIDICD10DIAGNOSISVERSION]', 'U') IS NULL
CREATE TABLE [STAGING].[COMORBIDICD10DIAGNOSISVERSION]
(
[ComorbidICD10DiagnosisVersionSID] [int] NULL,
[ICD10SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD10DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[COMORBIDICD9DIAGNOSISVERSION]'
GO
IF OBJECT_ID(N'[STAGING].[COMORBIDICD9DIAGNOSISVERSION]', 'U') IS NULL
CREATE TABLE [STAGING].[COMORBIDICD9DIAGNOSISVERSION]
(
[ComorbidICD9DiagnosisVersionSID] [int] NULL,
[ICD9SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD9DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[DUP_PATIENT]'
GO
IF OBJECT_ID(N'[STAGING].[DUP_PATIENT]', 'U') IS NULL
CREATE TABLE [STAGING].[DUP_PATIENT]
(
[dupcnt] [int] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Patient_id] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[DialysisType]'
GO
IF OBJECT_ID(N'[STAGING].[DialysisType]', 'U') IS NULL
CREATE TABLE [STAGING].[DialysisType]
(
[DialysisTypeSID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DialysisTypeDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DialysisTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[Dim_ComorbidICD10DiagnosisVersion]'
GO
IF OBJECT_ID(N'[STAGING].[Dim_ComorbidICD10DiagnosisVersion]', 'U') IS NULL
CREATE TABLE [STAGING].[Dim_ComorbidICD10DiagnosisVersion]
(
[ComorbidICD10DiagnosisVersionSID] [int] NULL,
[ICD10SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD10DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[Dim_ComorbidICD9DiagnosisVersion]'
GO
IF OBJECT_ID(N'[STAGING].[Dim_ComorbidICD9DiagnosisVersion]', 'U') IS NULL
CREATE TABLE [STAGING].[Dim_ComorbidICD9DiagnosisVersion]
(
[ComorbidICD9DiagnosisVersionSID] [int] NULL,
[ICD9SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD9DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[INPAT_CENSUSICDPROCEDURE]'
GO
IF OBJECT_ID(N'[STAGING].[INPAT_CENSUSICDPROCEDURE]', 'U') IS NULL
CREATE TABLE [STAGING].[INPAT_CENSUSICDPROCEDURE]
(
[CensusICDProcedureSID] [bigint] NULL,
[PTFIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTFChild_45_05IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OrdinalNumber] [smallint] NULL,
[Sta3n] [smallint] NULL,
[CensusSID] [bigint] NULL,
[PatientSID] [int] NULL,
[ParentFeeBasisFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTime] [datetime2] NULL,
[AdmitVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTimeTransformSID] [bigint] NULL,
[AdmitDateSID] [int] NULL,
[CensusDateTime] [datetime2] NULL,
[CensusVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CensusDateTimeTransformSID] [bigint] NULL,
[CensusDateSID] [int] NULL,
[ICD9ProcedureSID] [int] NULL,
[ICD10ProcedureSID] [int] NULL,
[ICDProcedureDateTime] [datetime2] NULL,
[ICDProcedureVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureDateTimeTransformSID] [bigint] NULL,
[ICDProcedureDateSID] [int] NULL,
[DialysisTreatmentCount] [smallint] NULL,
[DialysisTypeSID] [int] NULL,
[SpecialtySID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpecialtyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid-Etlid] on [STAGING].[INPAT_CENSUSICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid-Etlid' AND object_id = OBJECT_ID(N'[STAGING].[INPAT_CENSUSICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid-Etlid] ON [STAGING].[INPAT_CENSUSICDPROCEDURE] ([CensusICDProcedureSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-DiaSid] on [STAGING].[INPAT_CENSUSICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-DiaSid' AND object_id = OBJECT_ID(N'[STAGING].[INPAT_CENSUSICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-DiaSid] ON [STAGING].[INPAT_CENSUSICDPROCEDURE] ([PatientSID], [DialysisTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF OBJECT_ID(N'[STAGING].[INPAT_INPATIENTICDPROCEDURE]', 'U') IS NULL
CREATE TABLE [STAGING].[INPAT_INPATIENTICDPROCEDURE]
(
[InpatientICDProcedureSID] [bigint] NULL,
[PTFIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTFChild_45_05IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OrdinalNumber] [smallint] NULL,
[Sta3n] [smallint] NULL,
[PatientSID] [int] NULL,
[InpatientSID] [bigint] NULL,
[AdmitDateTime] [datetime2] NULL,
[AdmitVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTimeTransformSID] [bigint] NULL,
[AdmitDateSID] [int] NULL,
[DischargeDateTime] [datetime2] NULL,
[DIschargeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeDateTimeTransformSID] [bigint] NULL,
[DischargeDateSID] [int] NULL,
[ICD9ProcedureSID] [int] NULL,
[ICD10ProcedureSID] [int] NULL,
[ICDProcedureDateTime] [datetime2] NULL,
[ICDProcedureVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureDateTimeTransformSID] [bigint] NULL,
[ICDProcedureDateSID] [int] NULL,
[DialysisTreatmentCount] [smallint] NULL,
[DialysisTypeSID] [int] NULL,
[SpecialtySID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpecialtyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid-ETLId] on [STAGING].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid-ETLId' AND object_id = OBJECT_ID(N'[STAGING].[INPAT_INPATIENTICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid-ETLId] ON [STAGING].[INPAT_INPATIENTICDPROCEDURE] ([InpatientICDProcedureSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Patsid-Etlbatid] on [STAGING].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Patsid-Etlbatid' AND object_id = OBJECT_ID(N'[STAGING].[INPAT_INPATIENTICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Patsid-Etlbatid] ON [STAGING].[INPAT_INPATIENTICDPROCEDURE] ([PatientSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT]
(
[PATIENT_ID] [int] NOT NULL IDENTITY(1, 1),
[FIRST_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MIDDLE_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LAST_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EMAIL_ADDRESS] [varchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BIRTH_DATE] [date] NULL,
[DEATH_DATE] [date] NULL,
[CELL_PHONE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PERFERRED_ADDRESS_TYPE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[OEFOIF_IND] [bit] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENTSID] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PATIENT_ID_STAGING] on [STAGING].[PATIENT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_PATIENT_ID_STAGING' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT]'))
ALTER TABLE [STAGING].[PATIENT] ADD CONSTRAINT [PK_PATIENT_ID_STAGING] PRIMARY KEY CLUSTERED  ([PATIENT_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT_CPT]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT_CPT]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT_CPT]
(
[PATIENTSID] [int] NULL,
[CPTSID] [int] NULL,
[CPTCODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTDescription] [varchar] (8000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTCategory] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MajorCPTCategory] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Patsid] on [STAGING].[PATIENT_CPT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Patsid' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_CPT]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Patsid] ON [STAGING].[PATIENT_CPT] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-Sid-Code] on [STAGING].[PATIENT_CPT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-Sid-Code' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_CPT]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-Sid-Code] ON [STAGING].[PATIENT_CPT] ([PATIENTSID], [CPTSID], [CPTCODE])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT_ICD10]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT_ICD10]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT_ICD10]
(
[PATIENTSID] [int] NULL,
[ICD10SID] [int] NULL,
[ICD10CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid] on [STAGING].[PATIENT_ICD10]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_ICD10]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid] ON [STAGING].[PATIENT_ICD10] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-Sid-Code] on [STAGING].[PATIENT_ICD10]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-Sid-Code' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_ICD10]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-Sid-Code] ON [STAGING].[PATIENT_ICD10] ([PATIENTSID], [ICD10SID], [ICD10CODE])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT_ICD9]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT_ICD9]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT_ICD9]
(
[PATIENTSID] [int] NULL,
[ICD9SID] [int] NULL,
[ICD9CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid] on [STAGING].[PATIENT_ICD9]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_ICD9]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid] ON [STAGING].[PATIENT_ICD9] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-Sid-Code] on [STAGING].[PATIENT_ICD9]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-Sid-Code' AND object_id = OBJECT_ID(N'[STAGING].[PATIENT_ICD9]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-Sid-Code] ON [STAGING].[PATIENT_ICD9] ([PATIENTSID], [ICD9SID], [ICD9CODE])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT_REGISTRY_LoincCode]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT_REGISTRY_LoincCode]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT_REGISTRY_LoincCode]
(
[PATIENTSID] [int] NULL,
[PATIENTICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[STD_REGISTRY_ID] [int] NULL,
[CREATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATIENT_REGISTRY_StopCode]'
GO
IF OBJECT_ID(N'[STAGING].[PATIENT_REGISTRY_StopCode]', 'U') IS NULL
CREATE TABLE [STAGING].[PATIENT_REGISTRY_StopCode]
(
[PATIENTSID] [int] NULL,
[PATIENTICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[STD_REGISTRY_ID] [int] NULL,
[CREATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[PATSUB_PATIENTRACE]'
GO
IF OBJECT_ID(N'[STAGING].[PATSUB_PATIENTRACE]', 'U') IS NULL
CREATE TABLE [STAGING].[PATSUB_PATIENTRACE]
(
[PatientRaceSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientRaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[PatientSID] [int] NULL,
[RaceSID] [int] NULL,
[Race] [varchar] (45) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollectionMethodSID] [int] NULL,
[CollectionMethod] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LegacyRaceSID] [int] NULL,
[LegacyRace] [varchar] (45) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollectionMethodIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LegacyRaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
WITH
(
DATA_COMPRESSION = PAGE
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Patsid-RaceSid-ETLbID] on [STAGING].[PATSUB_PATIENTRACE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Patsid-RaceSid-ETLbID' AND object_id = OBJECT_ID(N'[STAGING].[PATSUB_PATIENTRACE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Patsid-RaceSid-ETLbID] ON [STAGING].[PATSUB_PATIENTRACE] ([PatientSID], [PatientRaceSID], [ETLBatchID]) WITH (DATA_COMPRESSION = PAGE)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-Race] on [STAGING].[PATSUB_PATIENTRACE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-Race' AND object_id = OBJECT_ID(N'[STAGING].[PATSUB_PATIENTRACE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-Race] ON [STAGING].[PATSUB_PATIENTRACE] ([PatientSID], [Race]) WITH (DATA_COMPRESSION = PAGE)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[REFERRAL]'
GO
IF OBJECT_ID(N'[STAGING].[REFERRAL]', 'U') IS NULL
CREATE TABLE [STAGING].[REFERRAL]
(
[STD_REFERRALSTS_ID] [int] NULL,
[STD_REGISTRY_ID] [int] NULL,
[PATIENT_ID] [int] NULL,
[REFERRAL_DATE] [datetime] NULL,
[REFERRAL_CLASS_TEXT] [varchar] (4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PROVIDER_ID] [int] NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[COMMENT_TEXT] [varchar] (4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[STD_REMINDERCLASS_ID] [int] NULL,
[REVIEW_BY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REVIEW_DATE] [datetime] NULL,
[DUPLICATE_FLAG] [bit] NULL,
[CREATEDSOURCE] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATEDSOURCE] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_AddressUpdate]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_AddressUpdate]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_AddressUpdate]
(
[StdRegistryId] [int] NULL,
[PatientSID] [int] NULL,
[StreetAddress1] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress2] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress3] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[City] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip4] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PostalCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Province] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Country] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BadAddressIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionSID] [int] NULL,
[AddressChangeStaffSID] [int] NULL,
[ConfidentialAddressActiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateSID] [int] NULL,
[State] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[County] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISLocatorName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchScore] [int] NULL,
[GISMatchMethodCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchedAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISAddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISStreetSide] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISPatientAddressLongitude] [float] NULL,
[GISPatientAddressLatitude] [float] NULL,
[GISAddressUpdatedDate] [date] NULL,
[GISFIPSCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSubmarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSector] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISURH] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISCongressDistrict] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_nonClustered_AddressUpdate_PatientSID_stdregistryID] on [STAGING].[SPATIENT_AddressUpdate]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_nonClustered_AddressUpdate_PatientSID_stdregistryID' AND object_id = OBJECT_ID(N'[STAGING].[SPATIENT_AddressUpdate]'))
CREATE NONCLUSTERED INDEX [indx_nonClustered_AddressUpdate_PatientSID_stdregistryID] ON [STAGING].[SPATIENT_AddressUpdate] ([StdRegistryId], [PatientSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Patsid-Regid] on [STAGING].[SPATIENT_AddressUpdate]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Patsid-Regid' AND object_id = OBJECT_ID(N'[STAGING].[SPATIENT_AddressUpdate]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Patsid-Regid] ON [STAGING].[SPATIENT_AddressUpdate] ([StdRegistryId], [PatientSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_MILITARYSERVICEEPISODE]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_MILITARYSERVICEEPISODE]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_MILITARYSERVICEEPISODE]
(
[MilitaryServiceEpisodeSID] [bigint] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryServiceEpisodeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ServiceEntryDate] [date] NULL,
[ServiceEntryVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceEntryDateTransformSID] [bigint] NULL,
[ServiceSeparationDate] [date] NULL,
[ServiceSeparationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceSeparationDateTransformSID] [bigint] NULL,
[BranchOfServiceSID] [int] NULL,
[ServiceComponent] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeTypeSID] [int] NULL,
[DataLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BranchOfServiceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_PLACEOFBIRTH]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_PLACEOFBIRTH]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_PLACEOFBIRTH]
(
[PlaceOfBirthSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSID] [int] NULL,
[Sta3n] [smallint] NULL,
[BirthDateTime] [datetime2] NULL,
[BirthVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BirthDateTimeTransformSID] [bigint] NULL,
[MultipleBirthFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthState] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthStateSID] [int] NULL,
[MotherName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MotherMaidenName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FatherName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_SPATIENTADDRESS]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_SPATIENTADDRESS]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_SPATIENTADDRESS]
(
[SPatientAddressSID] [int] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[OrdinalNumber] [smallint] NULL,
[AddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NameOfContact] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RelationshipToPatient] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BadAddressIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress1] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress2] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress3] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[City] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[County] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[State] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateSID] [int] NULL,
[Zip] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip4] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Province] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PostalCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Country] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmploymentStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Occupation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RetirementDateTime] [datetime2] NULL,
[RetirementVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RetirementDateTimeTransformSID] [bigint] NULL,
[AddressStartDateTime] [datetime2] NULL,
[AddressStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressStartDateTimeTransformSID] [bigint] NULL,
[AddressEndDateTime] [datetime2] NULL,
[AddressEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressEndDateTimeTransformSID] [bigint] NULL,
[AddressChangeStaffSID] [int] NULL,
[AddressChangeInstitutionSID] [int] NULL,
[AddressChangeDateTime] [datetime2] NULL,
[AddressChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeDateTimeTransformSID] [bigint] NULL,
[AddressChangeSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISLocatorName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchScore] [int] NULL,
[GISMatchMethodCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchedAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISAddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISStreetSide] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISPatientAddressLongitude] [float] NULL,
[GISPatientAddressLatitude] [float] NULL,
[GISAddressUpdatedDate] [date] NULL,
[GISFIPSCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSubmarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSector] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISURH] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISCongressDistrict] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_SPATIENTDISABILITY]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_SPATIENTDISABILITY]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_SPATIENTDISABILITY]
(
[SPatientDisabilitySID] [int] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ClaimFolderInstitutionSID] [int] NULL,
[ClaimNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedPercent] [decimal] (18, 0) NULL,
[SCAwardDateTime] [datetime2] NULL,
[SCAwardVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCAwardDateTimeTransformSID] [bigint] NULL,
[SCEffectiveDateTime] [datetime2] NULL,
[SCEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCEffectiveDateTimeTransformSID] [bigint] NULL,
[MedalOfHonorFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpinalCordInjuryCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SHADFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeExposureCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeRegistrationDateTime] [datetime2] NULL,
[AgentOrangeRegistrationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeRegistrationDateTimeTransformSID] [bigint] NULL,
[AgentOrangeLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeReportedDateTime] [datetime2] NULL,
[AgentOrangeReportedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeReportedDateTimeTransformSID] [bigint] NULL,
[AgentOrangeExamDateTime] [datetime2] NULL,
[AgentOrangeExamVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeExamDateTimeTransformSID] [bigint] NULL,
[AgentOrangeRegistrationNumber] [decimal] (18, 0) NULL,
[IonizingRadiationCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IonizingRadiationDateTime] [datetime2] NULL,
[IonizingRadiationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IonizingRadiationDateTimeTransformSID] [bigint] NULL,
[IonizingRadiationExposureCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaRegistrationDateTime] [datetime2] NULL,
[SWAsiaRegistrationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaRegistrationDateTimeTransformSID] [bigint] NULL,
[SWAsiaExamDateTime] [datetime2] NULL,
[SWAsiaExamVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaExamDateTimeTransformSID] [bigint] NULL,
[POWStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocationSID] [int] NULL,
[POWStartDateTime] [datetime2] NULL,
[POWStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWStartDateTimeTransformSID] [bigint] NULL,
[POWEndDateTime] [datetime2] NULL,
[POWEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWEndDateTimeTransformSID] [bigint] NULL,
[POWVerifiedDateTime] [datetime2] NULL,
[POWVerifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWVerifiedDateTimeTransformSID] [bigint] NULL,
[CombatServiceFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceStartDateTime] [datetime2] NULL,
[CombatServiceStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceStartDateTimeTransformSID] [bigint] NULL,
[CombatServiceEndDateTime] [datetime2] NULL,
[CombatServiceEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceEndDateTimeTransformSID] [bigint] NULL,
[CombatEligibilityEndDateTime] [datetime2] NULL,
[CombatEligibilityEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatEligibilityEndDateTimeTransformSID] [bigint] NULL,
[CombatEligibilityChangeDateTime] [datetime2] NULL,
[CombatEligibilityChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatEligibilityChangeDateTimeTransformSID] [bigint] NULL,
[CampLejeuneFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedDateTime] [datetime2] NULL,
[CampLejeuneModifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedDateTimeTransformSID] [bigint] NULL,
[CampLejeuneModifiedSite] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneDataLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnemployableFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingVADisability] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VADisabilityAmount] [decimal] (18, 0) NULL,
[PTDisabilityFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTEffectiveDateTime] [datetime2] NULL,
[PTEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTEffectiveDateTimeTransformSID] [bigint] NULL,
[AidAndAttendanceCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AidAndAttendanceAmount] [decimal] (18, 0) NULL,
[HouseboundCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HouseboundAmount] [decimal] (18, 0) NULL,
[ReceivingVAPension] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionAmount] [decimal] (18, 0) NULL,
[VAPensionEffectiveDateTime] [datetime2] NULL,
[VAPensionEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionEffectiveDateTimeTransformSID] [bigint] NULL,
[VAPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionTerminationDateTime] [datetime2] NULL,
[VAPensionTerminationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionTerminationDateTimeTransformSID] [bigint] NULL,
[FirstTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SecondTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ThirdTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FourthTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionIndicatorLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionEffectiveDateLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TotalVACheckAmount] [decimal] (18, 0) NULL,
[GovIssuedInsurance] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GovIssuedInsuranceAmount] [decimal] (18, 0) NULL,
[ReceivingMilitaryRetirement] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeDueToDisabilityFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryDisabilityRetirementFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryDisabilityRetirementCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingSocialSecurityBenefit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingSocialSecurityInsurance] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SocialSecurityInsuranceAmount] [decimal] (18, 0) NULL,
[OtherRetirementTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OtherRetirementAmount] [decimal] (18, 0) NULL,
[OtherIncomeAmount] [decimal] (18, 0) NULL,
[MonetaryBenefitVerifiedDateTime] [datetime2] NULL,
[MonetaryBenefitVerifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MonetaryBenefitVerifiedDateTimeTransformSID] [bigint] NULL,
[ClaimFolderInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocationIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_SPATIENTPHONE]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_SPATIENTPHONE]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_SPATIENTPHONE]
(
[SPatientPhoneSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSID] [int] NULL,
[Sta3n] [smallint] NULL,
[OrdinalNumber] [smallint] NULL,
[PatientContactType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NameOfContact] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RelationshipToPatient] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PhoneNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkPhoneNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmailAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeDateTime] [datetime2] NULL,
[ChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeDateTimeTransformSID] [bigint] NULL,
[ChangeInstitutionSID] [int] NULL,
[ChangeSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[SPATIENT_SPATIENT]'
GO
IF OBJECT_ID(N'[STAGING].[SPATIENT_SPATIENT]', 'U') IS NULL
CREATE TABLE [STAGING].[SPATIENT_SPATIENT]
(
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[PatientName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientLastName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientFirstName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TestPatientFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CDWPossibleTestPatientFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VeteranFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientTypeSID] [int] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ScrSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PseudoSSNReason] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SSNVerificationStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GovernmentEmployeeFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SensitiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Age] [numeric] (18, 0) NULL,
[BirthDateTime] [datetime2] NULL,
[BirthVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BirthDateTimeTransformSID] [bigint] NULL,
[DeceasedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDateTime] [datetime2] NULL,
[DeathVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDateTimeTransformSID] [bigint] NULL,
[DeathEnteredByStaffSID] [int] NULL,
[DeathNotificationSource] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDocumentationType] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathModifiedDateTime] [datetime2] NULL,
[DeathModifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathModifiedDateTimeTransformSID] [bigint] NULL,
[DeathLastUpdatedByStaffSID] [int] NULL,
[Gender] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SelfIdentifiedGender] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Religion] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionSID] [int] NULL,
[MaritalStatus] [varchar] (25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusSID] [int] NULL,
[CollateralSponsorPatientSID] [int] NULL,
[CurrentEnrollmentSID] [bigint] NULL,
[MeansTestStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentMeansTestStatusSID] [int] NULL,
[PeriodOfService] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceSID] [int] NULL,
[OperationDesertShieldRank] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSRankType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSRecalledCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSTreatmentDateTime] [datetime2] NULL,
[ODSTreatmentVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSTreatmentDateTimeTransformSID] [bigint] NULL,
[FederalAgencySID] [int] NULL,
[FilipinoVeteranCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Eligibility] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVACode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilitySID] [int] NULL,
[EligibilityStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityStatusDateTime] [datetime2] NULL,
[EligibilityStatusVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityStatusDateTimeTransformSID] [bigint] NULL,
[EligibilityVerificationSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVerificationMethod] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityInterimDateTime] [datetime2] NULL,
[EligibilityInterimVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityInterimDateTimeTransformSID] [bigint] NULL,
[EligibilityEnteredStaffSID] [int] NULL,
[IneligibleReason] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleVAROReason] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleStateSID] [int] NULL,
[IneligibleDateTime] [datetime2] NULL,
[IneligibleVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleDateTimeTransformSID] [bigint] NULL,
[IneligibleSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingDateTime] [datetime2] NULL,
[PatientMissingVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingDateTimeTransformSID] [bigint] NULL,
[PatientMissingCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingStateSID] [int] NULL,
[FugitiveFelonFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredDateTime] [datetime2] NULL,
[FFFEnteredVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredDateTimeTransformSID] [bigint] NULL,
[FFFEnteredStaffSID] [int] NULL,
[FFFRemovedReason] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedDateTime] [datetime2] NULL,
[FFFRemovedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedDateTimeTransformSID] [bigint] NULL,
[FFFRemovedStaffSID] [int] NULL,
[PatientEnteredByStaffSID] [int] NULL,
[PatientEnteredCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredRemark] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredDateTime] [datetime2] NULL,
[PatientEnteredVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredDateTimeTransformSID] [bigint] NULL,
[DuplicateRecordStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DestinationMergePatientSID] [int] NULL,
[PreferredInstitutionSID] [int] NULL,
[PreferredInstitutionSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmergencyResponseIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InsuranceCoverageFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidEligibleFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidInquireDateTime] [datetime2] NULL,
[MedicaidInquireVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidInquireDateTimeTransformSID] [bigint] NULL,
[VeteranTransportationProgramFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollateralSponsorPatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentEnrollmentIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentMeansTestStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathEnteredByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathLastUpdatedByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DestinationMergePatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityEnteredStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FederalAgencyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PreferredInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_APPOINTMENTSTATUS]'
GO
IF OBJECT_ID(N'[STAGING].[STD_APPOINTMENTSTATUS]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_APPOINTMENTSTATUS]
(
[AppointmentStatusSID] [smallint] NULL,
[AppointmentStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[AppointmentStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AppointmentStatusAbbreviation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CheckInAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CancelAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NoShowAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CheckOutAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [STAGING].[STD_APPOINTMENTSTATUS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[STAGING].[STD_APPOINTMENTSTATUS]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [STAGING].[STD_APPOINTMENTSTATUS] ([AppointmentStatusSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [STAGING].[STD_APPOINTMENTSTATUS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[STAGING].[STD_APPOINTMENTSTATUS]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [STAGING].[STD_APPOINTMENTSTATUS] ([AppointmentStatusSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_AppointmentType]'
GO
IF OBJECT_ID(N'[STAGING].[STD_AppointmentType]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_AppointmentType]
(
[AppointmentTypeSID] [smallint] NULL,
[AppointmentTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[AppointmentType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IgnoreMeansTestBillingFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AppointmentTypeSynonym] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DualEligibilityAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilitySID] [int] NULL,
[EligibilityIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [STAGING].[STD_AppointmentType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[STAGING].[STD_AppointmentType]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [STAGING].[STD_AppointmentType] ([AppointmentTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [STAGING].[STD_AppointmentType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[STAGING].[STD_AppointmentType]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [STAGING].[STD_AppointmentType] ([AppointmentTypeSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF OBJECT_ID(N'[STAGING].[STD_DRUGNAMEWITHOUTDOSE]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_DRUGNAMEWITHOUTDOSE]
(
[DrugNameWithoutDoseSID] [int] NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DrugNameWithoutDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDate] [date] NULL,
[VUID] [int] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [STAGING].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[STAGING].[STD_DRUGNAMEWITHOUTDOSE]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [STAGING].[STD_DRUGNAMEWITHOUTDOSE] ([DrugNameWithoutDoseSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [STAGING].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[STAGING].[STD_DRUGNAMEWITHOUTDOSE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [STAGING].[STD_DRUGNAMEWITHOUTDOSE] ([DrugNameWithoutDoseSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_DialysisType]'
GO
IF OBJECT_ID(N'[STAGING].[STD_DialysisType]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_DialysisType]
(
[DialysisTypeSID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DialysisTypeDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DialysisTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_ICD10Procedure_Code]'
GO
IF OBJECT_ID(N'[STAGING].[STD_ICD10Procedure_Code]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_ICD10Procedure_Code]
(
[ICD10PROCEDURESID] [int] NOT NULL,
[ICDPROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD10PROCEDURECODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10ProcedureDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDEXPANDEDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_ICD10_Code]'
GO
IF OBJECT_ID(N'[STAGING].[STD_ICD10_Code]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_ICD10_Code]
(
[ICD10SID] [int] NOT NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD10CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGIDENTIFIER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONSID] [int] NULL,
[REPRODUCTIVESYSTEMMDC13FLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MULTIPLESIGNIFICANTTRAUMAMDC24] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIVMDC25] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXPANDEDICDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNACCEPTABLEASPRIMARYFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10POAEXEMPTFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_ICD9Procedure_Code]'
GO
IF OBJECT_ID(N'[STAGING].[STD_ICD9Procedure_Code]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_ICD9Procedure_Code]
(
[ICD9PROCEDURESID] [int] NOT NULL,
[ICD9PROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD9PROCEDURECODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9ProcedureDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDEXPANDEDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_ICD9_CODE]'
GO
IF OBJECT_ID(N'[STAGING].[STD_ICD9_CODE]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_ICD9_CODE]
(
[ICD9SID] [int] NOT NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD9CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGIDENTIFIER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONSID] [int] NULL,
[REPRODUCTIVESYSTEMMDC13FLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MULTIPLESIGNIFICANTTRAUMAMDC24] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIVMDC25] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXPANDEDICDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNACCEPTABLEASPRIMARYFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_LABCHEMTESTURGENCY]'
GO
IF OBJECT_ID(N'[STAGING].[STD_LABCHEMTESTURGENCY]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_LABCHEMTESTURGENCY]
(
[LabChemTestUrgencySID] [int] NULL,
[LabChemTestUrgencyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[Urgency] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UrgencyAbbreviation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCollectFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkloadOnlyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HL7Code] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCodeSID] [int] NULL,
[LabelPrintFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCodeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_Sid] on [STAGING].[STD_LABCHEMTESTURGENCY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_Sid' AND object_id = OBJECT_ID(N'[STAGING].[STD_LABCHEMTESTURGENCY]'))
CREATE UNIQUE CLUSTERED INDEX [indx_Sid] ON [STAGING].[STD_LABCHEMTESTURGENCY] ([LabChemTestUrgencySID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_SID_LabSid] on [STAGING].[STD_LABCHEMTESTURGENCY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_SID_LabSid' AND object_id = OBJECT_ID(N'[STAGING].[STD_LABCHEMTESTURGENCY]'))
CREATE NONCLUSTERED INDEX [indx_SID_LabSid] ON [STAGING].[STD_LABCHEMTESTURGENCY] ([LabChemTestUrgencySID], [LabCodeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_LABCHEMTEST]'
GO
IF OBJECT_ID(N'[STAGING].[STD_LABCHEMTEST]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_LABCHEMTEST]
(
[LABCHEMTESTSID] [int] NOT NULL,
[LABCHEMTESTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[LABCHEMTESTNAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LABCHEMPRINTTESTNAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NLTNATIONALVALABCODESID] [int] NULL,
[NATIONALVALABCODESID] [int] NULL,
[LABCHEMTESTLOCATION] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LABTESTTYPE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REQUIREDTESTFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TESTCOST] [smallmoney] NULL,
[SNOMEDPROCEDURESID] [int] NULL,
[HIGHESTLABCHEMTESTURGENCYSID] [int] NULL,
[FORCEDLABCHEMTESTURGENCYSID] [int] NULL,
[DEFAULTSPECIMENSITECPTSID] [int] NULL,
[HCSPCSCPTSID] [int] NULL,
[COLLECTIONSAMPLESID] [int] NULL,
[BILLABLEFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNIQUECOLLECTIONSAMPLEFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNIQUEACCESSIONNUMBERFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COLLECTIONSAMPLEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DEFAULTSPECIMENSITECPTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FORCEDLABCHEMTESTURGENCYIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HCSPCSCPTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIGHESTLABCHEMTESTURGENCYIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NATIONALVALABCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NLTNATIONALVALABCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SNOMEDPROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid] on [STAGING].[STD_LABCHEMTEST]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid' AND object_id = OBJECT_ID(N'[STAGING].[STD_LABCHEMTEST]'))
CREATE UNIQUE CLUSTERED INDEX [indx_PatSid] ON [STAGING].[STD_LABCHEMTEST] ([LABCHEMTESTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_LOCALDRUG]'
GO
IF OBJECT_ID(N'[STAGING].[STD_LOCALDRUG]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_LOCALDRUG]
(
[LocalDrugSID] [int] NULL,
[LocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[LocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NonFormularyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalFormularyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDate] [date] NULL,
[InactivationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDateTransformSID] [bigint] NULL,
[LocalDrugMessage] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[QuantityDispensedMessage] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WarningLabel] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WarningMessageList] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StandardSig] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DEAHandling] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDosePerDay] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDosePerDayNumeric] [decimal] (18, 0) NULL,
[OrderUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PricePerOrderUnit] [smallmoney] NULL,
[DispenseUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitsPerOrderUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitsPerOrderUnitNumeric] [decimal] (18, 0) NULL,
[PricePerDispenseUnit] [smallmoney] NULL,
[CMOPDispenseFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CMOPID] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAClassification] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BestDrugClass] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrugSID] [int] NULL,
[NationalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugClassSID] [int] NULL,
[DrugClass] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ApplicationPackageUse] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NDC] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseSID] [int] NULL,
[DrugNameWithoutDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DayOrDoseLimit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseScheduleType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseSchedule] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PharmacyOrderableItemSID] [int] NULL,
[PharmacyOrderableItem] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseMedicationRouteSID] [int] NULL,
[UnitDoseMedicationRoute] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingInpatientLocalDrugSID] [int] NULL,
[CorrespondingInpatientLocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingOutpatientLocalDrugSID] [int] NULL,
[CorrespondingOutpatientLocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NCPDPDispenseUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NCPDPQuantityMultiplier] [decimal] (18, 0) NULL,
[DAW] [int] NULL,
[TopographySID] [int] NULL,
[SourceOfSupply] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AssociatedLabChemTestSID] [int] NULL,
[FederalStockNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrug] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AssociatedLabChemTestIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingInpatientLocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingOutpatientLocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugClassIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PharmacyOrderableItemIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TopographyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseMedicationRouteIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_LOINC_Code]'
GO
IF OBJECT_ID(N'[STAGING].[STD_LOINC_Code]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_LOINC_Code]
(
[LOINCSID] [int] NOT NULL,
[Sta3n] [smallint] NOT NULL,
[LOINCIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[LOINC] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Component] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Property] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TimeAspect] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ScaleType] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MethodType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NonPatientSpecimen] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Units] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_LOINC_ref]'
GO
IF OBJECT_ID(N'[STAGING].[STD_LOINC_ref]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_LOINC_ref]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[LOINC] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Component] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Property] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_STD_LOINC] on [STAGING].[STD_LOINC_ref]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_STD_LOINC' AND object_id = OBJECT_ID(N'[STAGING].[STD_LOINC_ref]'))
ALTER TABLE [STAGING].[STD_LOINC_ref] ADD CONSTRAINT [PK_STD_LOINC] PRIMARY KEY CLUSTERED  ([ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_NATIONALDRUG]'
GO
IF OBJECT_ID(N'[STAGING].[STD_NATIONALDRUG]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_NATIONALDRUG]
(
[NationalDrugSID] [int] NULL,
[NationalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DrugNameWithoutDoseSID] [int] NULL,
[NationalFormularyFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalFormularyName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VADrugPrintName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAProductIdentifier] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CMOPTransmitFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CSFederalSchedule] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ProductSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GCNSeqNo] [int] NULL,
[PreviousGCNSeqNo] [int] NULL,
[NDCToGCNSeqNo] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Strength] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StrengthNumeric] [decimal] (18, 0) NULL,
[DosageFormSID] [int] NULL,
[DispenseUnitSID] [int] NULL,
[DrugUnitSID] [int] NULL,
[PrimaryDrugClassSID] [int] NULL,
[DSSNumber] [int] NULL,
[InactivationDate] [date] NULL,
[InactivationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDateTransformSID] [bigint] NULL,
[ExcludeFromDrugInteractionCheckFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OverrideDoseCheckExclusionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CreateDefaultPossibleDosageFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PossibleDosagesToCreateIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FDAMedGuide] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChargemasterServiceCode] [int] NULL,
[OutpatientOrInpatientPackageUse] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxSingleDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MinSingleDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDailyDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MinDailyDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxCumulativeDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MasterEntryForVUIDFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VUID] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DosageFormIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugUnitIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryDrugClassIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [STAGING].[STD_NATIONALDRUG]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[STAGING].[STD_NATIONALDRUG]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [STAGING].[STD_NATIONALDRUG] ([NationalDrugSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [STAGING].[STD_NATIONALDRUG]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[STAGING].[STD_NATIONALDRUG]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [STAGING].[STD_NATIONALDRUG] ([NationalDrugSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_REFERRALSTS]'
GO
IF OBJECT_ID(N'[STAGING].[STD_REFERRALSTS]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_REFERRALSTS]
(
[CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[NAME] [varchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DESCRIPTION_TEXT] [varchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[SORT_ORDER] [int] NOT NULL,
[INACTIVE_FLAG] [bit] NOT NULL,
[INACTIVE_DATE] [datetime] NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATED] [datetime] NOT NULL,
[UPDATED] [datetime] NOT NULL,
[STD_REGISTRY_ID] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [STAGING].[STD_StopCode]'
GO
IF OBJECT_ID(N'[STAGING].[STD_StopCode]', 'U') IS NULL
CREATE TABLE [STAGING].[STD_StopCode]
(
[STOPCODESID] [int] NOT NULL,
[STOPCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[STOPCODE] [smallint] NULL,
[STOPCODENAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[INACTIVEDATE] [date] NULL,
[CONVERTTOSTOPCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COSTDISTRIBUTIONCENTER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RESTRICTIONTYPE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RESTRICTIONDATE] [date] NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
COMMIT TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
DECLARE @Success AS BIT
SET @Success = 1
SET NOEXEC OFF
IF (@Success = 1) PRINT 'The database update succeeded'
ELSE BEGIN
	IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
	PRINT 'The database update failed'
END
GO
